<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;

class BackupController extends Controller
{
    public function downloadBackup()
    {
        // Define the path where the backup will be saved
        $filePath = storage_path('app/backup.sql');

        // Get the database credentials from the .env file
        $dbHost = env('DB_HOST');
        $dbPort = env('DB_PORT', '3306'); // Default to 3306 if not set
        $dbName = env('DB_DATABASE');
        $dbUser = env('DB_USERNAME');
        $dbPassword = env('DB_PASSWORD');

        // Ensure all variables are properly set
        if (!$dbHost || !$dbName || !$dbUser) {
            return response()->json(['error' => 'Database credentials are not properly set.'], 500);
        }

        // Create a command to export the database
        $command = [
            'mysqldump',
            '--host=' . $dbHost,
            '--port=' . $dbPort,
            '--user=' . $dbUser,
            '--password=' . $dbPassword,
            $dbName
        ];

        // Create the Process instance
        $process = new Process($command);

        // Set the working directory where the backup file will be saved
        $process->setWorkingDirectory(storage_path('app'));

        try {
            // Run the process and capture the output directly to the file
            $process->run(function ($type, $buffer) use ($filePath) {
                if (Process::ERR === $type) {
                    file_put_contents($filePath, $buffer, FILE_APPEND);
                } else {
                    file_put_contents($filePath, $buffer, FILE_APPEND);
                }
            });

            // Check if the command was successful
            if (!$process->isSuccessful()) {
                throw new \Exception("Error: " . $process->getErrorOutput());
            }

            // Return the backup file as a download
            return response()->download($filePath)->deleteFileAfterSend(true);

        } catch (\Exception $exception) {
            // Log the error message
            \Log::error('Database backup failed: ' . $exception->getMessage());

            // Return a response with error details
            return response()->json(['error' => 'Database backup failed: ' . $exception->getMessage()], 500);
        }
    }
}
