<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSlidesTable extends Migration
{
    public function up()
    {
        Schema::create('slides', function (Blueprint $table) {
            $table->id();
            $table->string('group_name');
            $table->string('heading');
            $table->timestamps();
        });

        Schema::create('list_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('slide_id')->constrained()->onDelete('cascade');
            $table->string('list_name');
            $table->text('domains'); // Comma-separated list of domains
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('list_items');
        Schema::dropIfExists('slides');
    }
}

