@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-bold mb-4">Edit Backlink</h1>

    <form action="{{ route('backlinks.update', $backlink->id) }}" method="POST">
        @csrf
        @method('PUT')

        <!-- Title -->
        <div class="mb-4">
            <label class="block font-bold">Title:</label>
            <input type="text" name="title" value="{{ $backlink->title }}" class="w-full border p-2 rounded">
        </div>

        <!-- Backlinks -->
        <div class="mb-4">
            <label class="block font-bold">Backlinks:</label>
            <div id="backlink-container">
                @foreach($backlink->backlinks as $index => $link)
                <div class="backlink-item flex items-center gap-2 mb-2">
                    <input type="text" name="backlinks[{{ $index }}][label]" value="{{ $link['label'] }}" placeholder="Label" class="border p-2 rounded">
                    <input type="text" name="backlinks[{{ $index }}][href]" value="{{ $link['href'] }}" placeholder="URL" class="border p-2 rounded w-full">
                    <button type="button" class="bg-red-500 text-white px-3 py-1 rounded remove-backlink">Remove</button>
                </div>
                @endforeach
            </div>

            <!-- Add New Backlink Button -->
            <button type="button" id="add-backlink" class="mt-2 bg-green-500 text-white px-3 py-1 rounded">Add Backlink</button>
        </div>

        <!-- Domains -->
        <div class="mb-4">
            <label class="block font-bold">Domains:</label>
            <input type="text" name="domains" value="{{ $backlink->domains }}" class="w-full border p-2 rounded">
        </div>

        <!-- Submit Button -->
        <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Update Backlink</button>
    </form>
</div>

<!-- JavaScript for Adding & Removing Backlinks -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const backlinkContainer = document.getElementById("backlink-container");
        const addBacklinkBtn = document.getElementById("add-backlink");

        // Remove backlink field
        backlinkContainer.addEventListener("click", function(event) {
            if (event.target.classList.contains("remove-backlink")) {
                event.target.closest(".backlink-item").remove();
            }
        });

        // Add new backlink field
        addBacklinkBtn.addEventListener("click", function() {
            const index = backlinkContainer.children.length;
            const newBacklink = `
                <div class="backlink-item flex items-center gap-2 mb-2">
                    <input type="text" name="backlinks[${index}][label]" placeholder="Label" class="border p-2 rounded">
                    <input type="text" name="backlinks[${index}][href]" placeholder="URL" class="border p-2 rounded w-full">
                    <button type="button" class="bg-red-500 text-white px-3 py-1 rounded remove-backlink">Remove</button>
                </div>`;
            backlinkContainer.insertAdjacentHTML("beforeend", newBacklink);
        });
    });
</script>

@endsection
