@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <!-- SEO-friendly heading for the page -->
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Create Footer Backlink</h1>

    <!-- Main form container with a relevant title -->
    <section>
        <h2 class="text-2xl font-semibold text-gray-700 mb-4">Add a Footer Backlink</h2>

        <form action="{{ route('footer_backlinks.store') }}" method="POST" class="space-y-4">
            @csrf
            @include('footer_backlinks.form', ['footerBacklink' => null])

            <!-- Call-to-action buttons with meaningful text -->
            <div class="flex justify-between mt-6">
                <button type="submit" class="px-6 py-2 bg-green-500 text-white font-semibold rounded-md hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-green-500">Save Footer Backlink</button>
                <a href="{{ route('footer_backlinks.index') }}" class="px-6 py-2 bg-gray-500 text-white font-semibold rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500">Back to Backlinks List</a>
            </div>
        </form>
    </section>
</div>
@endsection
