@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <!-- SEO-friendly title tag for the page -->
    <title>Edit Hidden Backlink </title>

    <!-- Meta description for SEO -->
    <meta name="description" content="Edit an existing hidden backlink to improve SEO and website visibility on Your Website Name." />

    <!-- Main content section with relevant heading -->
    <section>

       
        <h1 class="text-3xl font-bold text-gray-800 mb-6">Edit Hidden Backlink</h1>

        <!-- Update hidden backlink form -->
        <h2 class="text-2xl font-semibold text-gray-700 mb-4">Update Hidden Backlink</h2>

        <form action="{{ route('hidden_backlinks.update', $hiddenBacklink) }}" method="POST" class="space-y-4">
            @method('PUT')
            @csrf
            @include('hidden_backlinks.form', ['hiddenBacklink' => $hiddenBacklink])

            <!-- Action buttons with accessible text -->
            <div class="flex justify-between mt-6">
                <button type="submit" class="px-6 py-2 bg-blue-500 text-white font-semibold rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    Update Hidden Backlink
                </button>
                <a href="{{ route('hidden_backlinks.index') }}" class="px-6 py-2 bg-gray-500 text-white font-semibold rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500">
                    Back to Hidden Backlinks List
                </a>
            </div>
        </form>
    </section>
</div>
@endsection
