

<?php $__env->startSection('title', $slide ?? null ? 'Edit Slide' : 'Create Slide'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-bold text-gray-900 mb-6"><?php echo e($slide ?? null ? 'Edit Slide' : 'Create Slide'); ?></h1>

    <form action="<?php echo e(route('slides.store')); ?>" method="POST" class="bg-white p-8 rounded-lg shadow-lg">
        <?php echo csrf_field(); ?>

        <!-- Group Name and Heading -->
        <div class="mb-6">
            <label for="group_name" class="block text-gray-700 font-medium mb-2">Group Name</label>
            <input type="text" name="group_name" id="group_name" placeholder="Enter group name" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300" required>
        </div>

        <div class="mb-6">
            <label for="heading" class="block text-gray-700 font-medium mb-2">Heading</label>
            <input type="text" name="heading" id="heading" placeholder="Enter heading" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300" required>
        </div>

        <!-- List Items -->
        <div id="list-items">
            <div class="list-item mb-6 bg-gray-50 p-6 rounded-lg shadow-sm border border-gray-200" data-index="0">
                <div class="mb-4">
                    <label for="list_items[0][list_name]" class="block text-gray-700 font-medium">List Name</label>
                    <input type="text" name="list_items[0][list_name]" id="list_items[0][list_name]" placeholder="Enter list name" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300" required>
                </div>

                <div class="mb-4">
                    <label for="list_items[0][domains]" class="block text-gray-700 font-medium">Domains (comma-separated)</label>
                    <input type="text" name="list_items[0][domains]" id="list_items[0][domains]" placeholder="Enter domains separated by commas (domain.com, domain.com)" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300" required>
                </div>

                <button type="button" class="remove-item-button bg-red-500 text-white py-2 px-4 rounded-lg flex items-center justify-center shadow-sm hover:bg-red-600 transition duration-300">
                    <i class="fas fa-trash mr-2"></i> Remove
                </button>
            </div>
        </div>

        <button type="button" id="add-item-button" class="bg-purple-600 hover:bg-purple-700 text-white py-3 px-6 rounded-lg flex items-center justify-center shadow-md transition duration-300 w-full mb-6">
            <i class="fas fa-plus mr-2"></i> Add More Domain List
        </button>

        <div class="flex space-x-4">
            <button type="submit" class="bg-green-500 hover:bg-green-600 text-white py-3 px-6 rounded-lg flex items-center justify-center shadow-md transition duration-300 w-full">
                <i class="fas fa-save mr-2"></i> Create Slider
            </button>
            <a href="<?php echo e(route('slides.index')); ?>" class="bg-gray-500 hover:bg-gray-600 text-white py-3 px-6 rounded-lg flex items-center justify-center shadow-md transition duration-300 w-full">
                <i class="fas fa-times mr-2"></i> Cancel
            </a>
        </div>
    </form>
</div>

<script>
    let itemIndex = 1;

    function addListItem() {
        const container = document.getElementById('list-items');
        const newItem = document.createElement('div');
        newItem.className = 'list-item mb-6 bg-gray-50 p-6 rounded-lg shadow-sm border border-gray-200';
        newItem.dataset.index = itemIndex;
        newItem.innerHTML = `
            <div class="mb-4">
                <label for="list_items[${itemIndex}][list_name]" class="block text-gray-700 font-medium">List Name</label>
                <input type="text" name="list_items[${itemIndex}][list_name]" id="list_items[${itemIndex}][list_name]" placeholder="Enter list name" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300" required>
            </div>
            <div class="mb-4">
                <label for="list_items[${itemIndex}][domains]" class="block text-gray-700 font-medium">Domains (comma-separated)</label>
                <input type="text" name="list_items[${itemIndex}][domains]" id="list_items[${itemIndex}][domains]" placeholder="Enter domains separated by commas" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300" required>
            </div>
            <button type="button" class="remove-item-button bg-red-500 text-white py-2 px-4 rounded-lg flex items-center justify-center shadow-sm hover:bg-red-600 transition duration-300">
                <i class="fas fa-trash mr-2"></i> Remove
            </button>
        `;
        container.appendChild(newItem);
        itemIndex++;
    }

    function removeListItem(event) {
        if (event.target.classList.contains('remove-item-button') || event.target.closest('.remove-item-button')) {
            event.target.closest('.list-item').remove();
        }
    }

    document.getElementById('add-item-button').addEventListener('click', addListItem);
    document.getElementById('list-items').addEventListener('click', removeListItem);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\shuvo\Desktop\pbn\pbn_slider\resources\views/slides/create.blade.php ENDPATH**/ ?>