

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-4">
    <h2 class="text-2xl font-semibold mb-4">Hidden Backlinks</h2>
    <a href="<?php echo e(route('hidden_backlinks.create')); ?>" class="inline-block bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600 mb-4">
        Add New
    </a>
    <div class="overflow-x-auto bg-white shadow-md rounded-lg">
        <table class="min-w-full table-auto text-left">
            <thead class="bg-gray-100">
                <tr>
                    <th class="py-2 px-4 font-semibold text-gray-700">Title</th>
                    <th class="py-2 px-4 font-semibold text-gray-700">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $backlinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backlink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border-b">
                    <td class="py-2 px-4 text-gray-800"><?php echo e($backlink->title); ?></td>
                    <td class="py-2 px-4 flex gap-5">
                        <a href="<?php echo e(route('hidden_backlinks.edit', $backlink)); ?>" class="bg-yellow-500 text-white py-1 px-3 rounded-lg hover:bg-yellow-600">Edit</a>
                        <form action="<?php echo e(route('hidden_backlinks.destroy', $backlink)); ?>" method="POST" class="inline-block" onsubmit="return confirmDelete()">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="bg-red-500 text-white py-1 px-3 rounded-lg hover:bg-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<script>
    function confirmDelete() {
        return confirm('Are you sure you want to delete this backlink? This action cannot be undone.');
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Downloads\PBN_Panel\resources\views/hidden_backlinks/index.blade.php ENDPATH**/ ?>